
float ld(const float dist)
{
    return (2.0 * near) / (far + near - dist * (far - near));
}

vec2 spherical_coordinates(vec3 xyz)
{
    // Cartesian coordinates
    float x = xyz.x;
    float y = xyz.y;
    float z = xyz.z;

    // Compute spherical coordinates
    float theta = acos(z / length(xyz)); // Polar angle
    float phi = (atan(y, x) + 1.5708);   // Azimuthal angle

    // Normalize to [0, 1] for UV mapping
    float u = phi / TWO_PI;
    if (u < 0.0)
        u += 1.0;
    float v = theta / PI;

    return vec2(u, v);
}
vec3 spherical_surface(vec2 uv)
{

    // Adjust phi to range from 0 to 2PI for a full rotation around the sphere
    float phi = (TWO_PI * uv.x - 1.5708); // Azimuthal angle
    // theta remains as is, ranging from 0 to PI to cover from pole to pole
    float theta = PI * uv.y; // Polar angle

    // Compute spherical coordinates
    float phi_s = sin(phi);

    float phi_c = cos(phi);
    float theta_s = sin(theta);

    float theta_c = cos(theta);

    // Convert to Cartesian coordinates
    return vec3(theta_s * phi_c, theta_s * phi_s, theta_c);
}

vec3 mapUVToSphere(vec2 uv)
{

    return spherical_surface(uv);
}

vec4 skyFromTex2(vec3 pos, sampler2D sampler)
{
    vec2 p = spherical_coordinates(normalize(pos));

    return texture2D(sampler, p);
}
vec4 skyFromTexLod(vec3 pos, sampler2D sampler, float LOD)
{
    vec2 p = spherical_coordinates(normalize(pos));

    return texture2DLod(sampler, p, LOD);
}
#include "/lib/encoding.glsl"


#define vmax(a, b) max(a, vec3(b))
#define MAD(a, b, c) ((a) * (b) + (c))
#define UNROLL for (int _ = 0; _ < 1; _++)
#define DIE renderError()

float renderError() {
    return sqrt(-1.0); // NaN
}
